---
generated_at: 2026-02-04 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：80-Spark Connectサーバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **gRPC設定パラメータのデフォルト値**: 設定キーの存在は確認済みだが一部デフォルト値が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala`
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectServer.scala`
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectSessionManager.scala`
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectExecutionManager.scala`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkConnectServiceはAsyncServiceとBindableServiceを実装 | E-01 (58行目) | ○ |
| C-02 | executePlanはSparkConnectExecutePlanHandlerに委譲 | E-01 (70-82行目) | ○ |
| C-03 | analyzePlanはSparkConnectAnalyzeHandlerに委譲 | E-01 (96-108行目) | ○ |
| C-04 | SparkConnectServer.mainでSparkSession構築 | E-02 (33-37行目) | ○ |
| C-05 | ARTIFACTS_SESSION_ISOLATION_ENABLED = true | E-02 (35行目) | ○ |
| C-06 | NettyServerBuilderでgRPCサーバー構築 | E-01 (390-394行目) | ○ |
| C-07 | PreSharedKeyAuthenticationInterceptorの条件付き登録 | E-01 (399-401行目) | ○ |
| C-08 | sessionStoreはConcurrentHashMap | E-03 (48-49行目) | ○ |
| C-09 | computeIfAbsentでスレッドセーフなセッション作成 | E-03 (213行目) | ○ |
| C-10 | セッションタイムアウト判定: lastAccessTimeMs + timeoutMs <= nowMs | E-03 (336行目) | ○ |
| C-11 | sessionIdのUUID形式バリデーション | E-03 (370-377行目) | ○ |
| C-12 | 閉じたセッションのtombstoneキャッシュ | E-03 (51-55行目) | ○ |
| C-13 | executionsはConcurrentHashMap | E-04 (69-70行目) | ○ |
| C-14 | operationId重複チェック(OPERATION_ALREADY_EXISTS) | E-04 (98-101行目) | ○ |
| C-15 | abandonedTombstonesで放棄実行を記録 | E-04 (73-76行目) | ○ |
| C-16 | detachedTimeout判定: detachedNs + timeoutNs <= nowNs | E-04 (339行目) | ○ |
| C-17 | reattachExecuteはreattachableチェック付き | E-04 (220-229行目) | ○ |
| C-18 | gRPC設定パラメータの一部デフォルト値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: gRPC設定パラメータの具体的なデフォルト値。設定キーの存在はインポート文から確認できるが、デフォルト値はConnect設定ファイルの参照が必要
  - 候補: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/config/Connect.scala`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバー基盤の設計は安定しており、主要な機能は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各RPCメソッドのエラーハンドリング（ErrorUtils.handleError）が正しく設定されているか
- [ ] セッションタイムアウトとデタッチタイムアウトの設定値が適切か
- [ ] tombstoneキャッシュのmaximumSizeが適切か
- [ ] gRPC設定パラメータのデフォルト値をConnect設定ファイルから確認
